import React from 'react';
import { CircularProgressbarWithChildren } from 'react-circular-progressbar';
import deviceUpdateIcon from 'resources/images/device_update.svg';
import warningIcon from 'resources/images/warning.svg';
import Footer from '../Footer';
import useStyles from './styles';

type Props = {
    strings: object,
    device: object,
    language: string,
    updatingFirmwareStatus: stirng,
    fwUpdateProgress: number
};

function UpdatingFirmware({
    strings,
    device,
    updatingFirmwareStatus,
    fwUpdateProgress,
    language
}: Props) {
    const classes = useStyles();
    return (
        <div className={classes.updatingFirmwareContainer}>
            <div className={classes.updatingFirmwareProgressContainer}>
                <CircularProgressbarWithChildren
                    classes={{
                        path: classes.updatingFirmwareProgressBar,
                        trail: classes.updatingFirmwareProgressBarTrail
                    }}
                    className={classes.updatingFirmwareProgress}
                    value={fwUpdateProgress}
                >
                    <img
                        className={classes.updatingFirmwareProgressBarIcon}
                        src={deviceUpdateIcon}
                        alt="Device Icon"
                    />
                </CircularProgressbarWithChildren>
            </div>
            <div className={classes.updatingFirmwareTitle}>
                {updatingFirmwareStatus}
            </div>
            <div className={classes.updatingFirmwareSubContainer}>
                <img src={warningIcon} alt="Warning Icon" />
                <div className={classes.updatingFirmwareSubTitle}>
                    {strings.update_device_updating_description}
                </div>
            </div>
            <Footer strings={strings} device={device} language={language} />
        </div>
    );
}

export default UpdatingFirmware;
